#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int maksimalnaSreca(int N, vector<int>& gornji, vector<int>& donji) {
    vector<int> parnostiGornji(N), parnostiDonji(N);
    for (int i = 0; i < N; i++) {
        parnostiGornji[i] = gornji[i] % 2;
        parnostiDonji[i] = donji[i] % 2;
    }


    int srecaBezZamene = 0;
    int prethodnaParnost = parnostiGornji[0];
    for (int i = 1; i < N; i++) {
        int trenutnaParnost = (i % 2 == 0) ? parnostiGornji[i] : parnostiDonji[i];
        if (trenutnaParnost == prethodnaParnost) {
            srecaBezZamene++;
        }
        prethodnaParnost = trenutnaParnost;
    }

    int srecaSaZamenom = 0;
    prethodnaParnost = parnostiDonji[0];
    for (int i = 1; i < N; i++) {
        int trenutnaParnost = (i % 2 == 0) ? parnostiDonji[i] : parnostiGornji[i];
        if (trenutnaParnost == prethodnaParnost) {
            srecaSaZamenom++;
        }
        prethodnaParnost = trenutnaParnost;
    }

    return max(srecaBezZamene, srecaSaZamenom);
}

int main() {
    int T;
    cin >> T; 

    while (T--) {
        int N;
        cin >> N; 

        vector<int> gornji(N), donji(N);
        for (int i = 0; i < N; i++) {
            cin >> gornji[i];
        }
        for (int i = 0; i < N; i++) {
            cin >> donji[i];
        }

        int rezultat = maksimalnaSreca(N, gornji, donji);
        cout << rezultat << endl;
    }

    return 0;
}